#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "map.h"
#include "gmstuff.h"
#include "mapstuff.h"
#include "switchstuff.h"
#include "linkstuff.h"

char *Mapfile1;
char *Mapfile2;

void
parse_args(
  int argc,
  char **argv)
{
  if (argc != 3) {
    fprintf(stderr, "Usage: mapcmp <map1> <map2>\n");
    exit(1);
  }

  Mapfile1 = argv[1];
  Mapfile2 = argv[2];
}

int
main(
  int argc,
  char **argv)
{
  parse_args(argc, argv);

  load_map_file();
  find_self();
  calc_xbar_routes();	/* calculate routes to all xbars */

  check_all_links();

  close_gm();

  return 0;
}
